<?php

namespace  Modules\\Tax\\Entities\\Core;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Itemable extends Model 
{

    protected $table = 'itemables';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function item()
    {
        return $this->belongsTo('Item', 'item_id');
    }

    public function itemable()
    {
        return $this->morphTo();
    }

}